<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 30. May 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * Test class file for OpenDocumentText.  
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: OpenDocumentTextTest.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: OpenDocumentTextTest.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.3 - 01. Aug. 2007
 */

/**
 *  
 */
// Call MetaTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
	define("PHPUnit_MAIN_METHOD", "OpenDocumentTextTest::main");
}

/**
 * 
 */
require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";
require_once "PHPUnit/TextUI/TestRunner.php";

/**
 * 
 */
require_once 'OpenDocumentPHP/OpenDocumentText.php';
require_once 'tools/DOMCompare.php';

/**
 * Test class for OpenDocumentText.
 * 
 * *** FIX ME ***
 * 
 * Currently we only have bad tests in this unit test. Instead of testing file size and 
 * the content as string, we should test each xml document of the SimpleDocument against 
 * the 'new' OpenDocuments. 
 * Every (or nearly every) document should be DOM-equalvalent in the sense of DOMCompare.
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since 		0.5.2 - 30. May 2007
 */
class OpenDocumentTextTest extends PHPUnit_Framework_TestCase 
{
	const etcdir = 'etc/';
	
	private $basepath;
	
	private $ODTTempFile;
	
	private $doc;
	
	private $FileSize;
	
	private $FileContent;

	/**
	 * Runs the test methods of this class.
	 *
	 * @access 		public
	 * @static
	 * @since 		0.5.2 - 30.05.2007
	 */
    public static function main() 
    {
        $result = PHPUnit_TextUI_TestRunner :: run(self::suite());
    }
    
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     * @since       0.5.3 - 02. Aug. 2007
     */
    public static function suite() 
    {
        $suite = new PHPUnit_Framework_TestSuite("basic tests");
        $suite->addTestSuite('OpenDocumentTextTest');
        return $suite;
    }
        
	
	/**
	 * Sets up the fixture, for example, open a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access 		protected
	 * @since 		0.5.2 - 30.05.2007
	 */
	protected function setUp() 
	{
        if (PHPUnit_MAIN_METHOD == 'PHPUnit_TextUI_Command::main') {
            $this->basepath = "../";
        } else {
            $this->basepath = "./";
        }
	
		// We want to have a temporary copy of a good OpenDocument file which we can use for our tests
		$this->ODTTempFile = tempnam( '/usr/tmp/', 'ODTTempFile' );
		unlink($this->ODTTempFile);
		$this->ODTTempFile = $this->ODTTempFile . '.odt';
		//
		copy( $this->basepath . self::etcdir . 'SimpleText.odt', $this->ODTTempFile );
		$this->FileSize = filesize( $this->basepath . self::etcdir . 'SimpleText.odt' );
		$this->FileContent = file_get_contents( $this->basepath . self::etcdir . 'SimpleText.odt' );		
		//$this->assertsTrue( copy( self::etcdir . 'SimpleText.odt', $this->ODTTempFile ), 'Could not copy temporary OpenDocument file!' );
	}
	
	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access 		protected
	 * @since 		0.5.2 - 30.05.2007
	 */
	protected function tearDown() 
	{
		// If the temporary file does still exists, remove it.
		if ( file_exists( $this->ODTTempFile ) ) {
			unlink( $this->ODTTempFile );
		}				
	}
	
	/**
	 * If we want to read-only a OpenDocument, we should garantee that we did not change a single line.
	 * This unit test we check this.
	 *
	 * @access 		public
	 * @since 		0.5.3 - 19.06.2007
	 */
	function testOpenAndCloseWithoutWritingViaConstrutor() 
	{
	 $this->markTestIncomplete(
          'This test has not been implemented yet.'
        );
/*          
		// Try to load an existing file
		$text = new OpenDocumentText( $this->ODTTempFile );
		$text->close( false );
		// And now run the tests...
	    $filesize = filesize( $this->ODTTempFile );
	    $this->assertEquals($filesize, $this->FileSize, 'Files should not be different in size!');
	    $content = file_get_contents( $this->ODTTempFile );
	    $this->assertEquals($content, $this->FileContent, 'Files should not de different in content!');
*/
	}
	
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 30.05.2007
	 */
	function testLoadExistingFileViaConstrutor() 
	{
		// Try to load an existing file
		$text = new OpenDocumentText( $this->ODTTempFile );
		$text->close();
		// And now run the tests...
	    $filesize = filesize( $this->ODTTempFile );
	    $this->assertEquals($filesize, $this->FileSize, 'Files should not be different in size!');
	    $content = file_get_contents( $this->ODTTempFile );
	    $this->assertEquals($content, $this->FileContent, 'Files should not de different in content!');
	}
	
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 *
	 * @access 		public
	 * @since 		0.5.2 - 30.05.2007
	 */
	function testLoadExistingFileViaOpen() 
	{
		// Try to load an existing file
		$text = new OpenDocumentText( );
		$text->open( $this->ODTTempFile );
		$text->close();
		// And now run the tests...
		$filesize = filesize( $this->ODTTempFile );
		$this->assertEquals($filesize, $this->FileSize, 'Files should not be different in size!');
		$content = file_get_contents( $this->ODTTempFile );
		$this->assertEquals($content, $this->FileContent, 'Files should not de different in content!');
	}
}

if (PHPUnit_MAIN_METHOD == "OpenDocumentTextTest::main") {
	OpenDocumentTextTest::main();
}
?>
